<?php

namespace App\Services;

class SignatureService
{
    /**
     * Generate HMAC signature for the given payload and secret.
     */
    public function generateSignature(array $payload, string $secret): string
    {
        // Sort keys to ensure consistent order
        ksort($payload);

        // Build query string
        $queryString = http_build_query($payload);

        return hash_hmac('sha256', $queryString, $secret);
    }

    /**
     * Verify the provided signature against the payload.
     */
    public function verifySignature(array $payload, string $signature, string $secret): bool
    {
        $calculatedSignature = $this->generateSignature($payload, $secret);
        return hash_equals($calculatedSignature, $signature);
    }
}
